@extends('layouts.syndron.app')

@section('content')

<div class="card">
    <div class="card-header d-flex justify-content-between">
        <div>
            <h4>
                {{ __('Roles') }}
            </h4>
        </div>
        <div>
            <a class="btn btn-success" href="{{ route('admin.settings.permission.create') }}">
                {{ __('Create a new permission') }}
            </a>
        </div>
    </div>

    <div class="card-body">
        <x-syndron.ui.table :columns="['name' , 'guard' , 'actions']">
            @foreach ($permissions as $permission )
            <tr>
                <td>{{ $permission->name  }}</td>
                <td>{{ $permission->guard_name  }}</td>

                <td>
                    @if (in_array($permission->name , config('app.permissions')))
                    <p> {{ __('create by system') }} </p>
                    @else
                    <div class="dropdown">
                        <button class="btn btn-secondary dropdown-toggle" type="button" id="dropdownMenuButton" data-bs-toggle="dropdown" aria-expanded="false">
                            {{ __('Actions') }}
                        </button>
                        <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton">

                            @can('settings.permission.edit')
                            <li><a class="dropdown-item" href="{{ route('admin.settings.permission.edit' , $permission->id) }}">{{ __('Edit') }}</a></li>
                            @endcan

                            @can('settings.permission.delete')
                            <li>
                                <form action="{{ route('admin.settings.permission.destroy' , $permission->id) }}" method="POST" onsubmit="return confirm('<?php echo __('Are you sure you want to delete this attribute?') ?>');">
                                    @csrf
                                    @method('DELETE')
                                    <button class="dropdown-item text-danger" type="submit">{{ __('Delete') }}</button>
                                </form>
                            </li>
                            @endcan
                        </ul>
                    </div>
                    @endif

                </td>
            </tr>
            @endforeach
        </x-syndron.ui.table>
    </div>
</div>
@endsection
