@extends('layouts.syndron.app')

@section('content')

<div class="card">
    <div class="card-header d-flex justify-content-between">
        <div>
            <h4>
                {{ __('Roles') }}
            </h4>
        </div>
        <div>
            <a class="btn btn-success" href="{{ route('admin.settings.role.create') }}">
                {{ __('Create a new role') }}
            </a>
        </div>
    </div>

    <div class="card-body">
        <x-syndron.ui.table :columns="['name' , 'guard' , 'actions']">
            @foreach ($roles as $role )
            <tr>
                <td>{{ $role->name  }}</td>
                <td>{{ $role->guard_name  }}</td>

                <td>
                    @if (in_array($role->name , config('app.roles')) && !auth()->user()->isSuperAdmin())
                    <p> {{ __('create by system') }} </p>
                    @else
                    <div class="dropdown">
                        <button class="btn btn-secondary dropdown-toggle" type="button" id="dropdownMenuButton" data-bs-toggle="dropdown" aria-expanded="false">
                            {{ __('Actions') }}
                        </button>
                        <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                            @can('settings.role.edit')
                            <li><a class="dropdown-item" href="{{ route('admin.settings.role.edit' , $role->id) }}">{{ __('Edit') }}</a></li>
                            @endcan

                            @can('settings.role.delete')
                            <li>
                                <form action="{{ route('admin.settings.role.destroy' , $role->id) }}" method="POST" onsubmit="return confirm('<?php echo __('Are you sure you want to delete this attribute?') ?>');">
                                    @csrf
                                    @method('DELETE')
                                    <button class="dropdown-item text-danger" type="submit">{{ __('Delete') }}</button>
                                </form>
                            </li>
                            @endcan
                        </ul>
                    </div>
                    @endif

                </td>
            </tr>
            @endforeach
        </x-syndron.ui.table>
    </div>
</div>
@endsection
