@extends('layouts.syndron.app')

@section('title', 'Shop Profile Details')

@section('content')
<div class="container-fluid">
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">{{__('Shop')}}: {{ $shop->name }}</h1>
        <div>
            <a href="{{ route('admin.shops.edit', $shop) }}" class="btn btn-sm btn-warning shadow-sm">
                <i class="fas fa-edit fa-sm text-white-50"></i> {{__('Edit Shop')}}
            </a>
            <a href="{{ route('admin.shops.index') }}" class="btn btn-sm btn-secondary shadow-sm">
                <i class="fas fa-arrow-left fa-sm text-white-50"></i> {{__('Back to List')}}
            </a>
        </div>
    </div>

    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">{{__('Shop Information')}}</h6>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-3 text-center">
                    @if ($shop->logo)
                    <img src="{{ asset('uploads/' . $shop->logo) }}" alt="{{ $shop->name }} Logo" class="img-fluid rounded mb-3" style="max-height: 200px;">
                    @else
                    <p class="text-muted">{{__('No logo uploaded')}}.</p>
                    @endif
                    <p>
                        <strong>{{__('Status')}}:</strong>
                        @if ($shop->is_approved)
                        <span class="badge bg-success">{{__('Approved')}}</span>
                        (on {{ $shop->approved_at ? \Carbon\Carbon::parse($shop->approved_at)->format('M d, Y') : 'N/A' }})
                        @else
                        <span class="badge bg-warning text-dark">{{__('Pending Approval')}}</span>
                        @endif
                    </p>
                </div>
                <div class="col-md-9">
                    <dl class="row">
                        <dt class="col-sm-3">{{__('Shop Name')}}:</dt>
                        <dd class="col-sm-9">{{ $shop->name }}</dd>

                        <dt class="col-sm-3">{{__('Slug')}}:</dt>
                        <dd class="col-sm-9">{{ $shop->slug }}</dd>

                        <dt class="col-sm-3">{{__('Owner')}}:</dt>
                        <dd class="col-sm-9">{{ $shop->user?->name ?? 'N/A' }} ({{ $shop->user?->email ?? '' }})</dd>

                        <dt class="col-sm-3">{{__('Email')}}:</dt>
                        <dd class="col-sm-9">{{ $shop->email }}</dd>

                        <dt class="col-sm-3">{{__('Phone')}}:</dt>
                        <dd class="col-sm-9">{{ $shop->phone }}</dd>

                        <dt class="col-sm-3">{{__('Address')}}:</dt>
                        <dd class="col-sm-9">{{ $shop->address }}</dd>

                        <dt class="col-sm-3">{{__('City')}}:</dt>
                        <dd class="col-sm-9">{{ $shop->city }}</dd>

                        <dt class="col-sm-3">{{__('State/Province')}}:</dt>
                        <dd class="col-sm-9">{{ $shop->state ?? 'N/A' }}</dd>

                        <dt class="col-sm-3">{{__('Postal Code')}}:</dt>
                        <dd class="col-sm-9">{{ $shop->postal_code }}</dd>

                        <dt class="col-sm-3">{{__('Country')}}:</dt>
                        <dd class="col-sm-9">{{ $shop->country }}</dd>

                        <dt class="col-sm-3">{{__('Description')}}:</dt>
                        <dd class="col-sm-9">{{ $shop->description ?? 'N/A' }}</dd>

                        <dt class="col-sm-3">{{__('Created At')}}:</dt>
                        <dd class="col-sm-9">{{ $shop->created_at->format('M d, Y H:i A') }}</dd>

                        <dt class="col-sm-3">{{__('Last Updated')}}:</dt>
                        <dd class="col-sm-9">{{ $shop->updated_at->format('M d, Y H:i A') }}</dd>
                    </dl>
                </div>
            </div>
        </div>
        <div class="card-footer d-flex justify-content-end">
            @if ($shop->is_approved)
            <form action="{{ route('admin.shops.unapprove', $shop) }}" method="POST" class="d-inline me-2" onsubmit="return confirm('Are you sure you want to unapprove this shop?');">
                @csrf
                @method('PATCH')
                <button type="submit" class="btn btn-warning">{{__('Unapprove Shop')}}</button>
            </form>
            @else
            <form action="{{ route('admin.shops.approve', $shop) }}" method="POST" class="d-inline me-2" onsubmit="return confirm('Are you sure you want to approve this shop?');">
                @csrf
                @method('PATCH')
                <button type="submit" class="btn btn-success">{{__('Approve Shop')}}</button>
            </form>
            @endif
            <form action="{{ route('admin.shops.destroy', $shop) }}" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this shop? This action cannot be undone.');">
                @csrf
                @method('DELETE')
                <button type="submit" class="btn btn-danger">{{__('Delete Shop')}}</button>
            </form>
        </div>
    </div>
</div>
@endsection
