@extends('layouts.syndron.app')

@section('content')
<div>

    <div class="card">
        <div class="card-body">
            @if (auth()->user()->shop->hasOneWarehouse())
            <form action="{{ route('admin.shop.inventory.variant.store' , $inventory->id) }}" method="post">

                @csrf
                <x-syndron.form.product.category-attributes :category="$product->category" is_price_effective="1" item_value="0" />

                @error('attributes')
                <small class="text-danger"> {{ $message }} </small>
                @enderror
                <div class="mb-3">
                    <label for="price">{{ __('Price') }}</label>
                    <input type="text" name="price" class="form-control" id="price" value="{{ old('price') }}" placeholder="{{ __('Price') }}">
                    @error('price')
                    <small class="text-danger"> {{ $message }} </small>
                    @enderror
                </div>
                <div class="row">

                    <div class="col-sm-4 mb-3">
                        <label for="">{{ __(key: 'Warehouse') }}</label>
                        <select name="warehouse_id" class="form-control" id="">
                            <option value="">{{ __('Select Warehouse') }}</option>
                            @foreach (auth()->user()->shop->warehouses as $warehouse)
                            <option value="{{ $warehouse->id }}">{{ $warehouse->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-sm-8 mb-3">
                        <label for="inventory_count">{{ __('Inventory Count') }}</label>
                        <input type="text" name="inventory_count" class="form-control" id="inventory_count" value="{{ old('inventory_count') }}" placeholder="{{ __('Inventory Count') }}">
                        @error('inventory_count')
                        <small class="text-danger"> {{ $message }} </small>
                        @enderror
                    </div>
                </div>
                <div class="d-flex justify-content-end">
                    <button class="btn btn-primary px-5" type="submit">
                        {{ __('Add') }}
                    </button>
                </div>
            </form>
            @else
            <div class="alert alert-warning">
                {{ __('You must create at least one warehouse before adding inventory variants.') }}
                <strong>
                    <a href="{{ route('admin.warehouses.create') }}">{{ __('Create Warehouse') }}</a>
                </strong>
            </div>
            @endif
        </div>
    </div>

    <x-syndron.ui.table :columns="['#','Combination','SKU','Barcode','Price','Stock','Status','Action']">
        @forelse ($variants as $variant)
        @php
        $variant_label = collect($variant->resolveCombination($variant->combination_items))
        ->map(fn($r) => "{$r['attribute']}: {$r['item']}")
        ->join(', ');
        @endphp
        <tr>
            <td>{{ $loop->iteration }}</td>
            <td>{{ $variant_label }}</td>
            <td><span class="font-monospace">{{ $variant->sku_code ?? '—' }}</span></td>
            <td><span class="font-monospace">{{ $variant->barcode ?? '—' }}</span></td>
            <td>{{ number_format($variant->price_override) }}</td>
            <td>{{ $variant->getInventory() }}</td>
            <td>
                @if(($variant->status ?? 'inactive') === 'active')
                <span class="badge bg-success">{{ __('Active') }}</span>
                @else
                <span class="badge bg-secondary">{{ __('Inactive') }}</span>
                @endif
            </td>
            <td>
                <div class="dropdown">
                    <button class="btn btn-outline-secondary btn-sm dropdown-toggle"
                        type="button" id="v-{{ $variant->id }}-dd"
                        data-bs-toggle="dropdown" aria-expanded="false">
                        {{ __('Actions') }}
                    </button>
                    <ul class="dropdown-menu" aria-labelledby="v-{{ $variant->id }}-dd">
                        @can('shop.inventory.variant.edit')
                        <li>
                            <a class="dropdown-item"
                                href="{{ route('admin.shop.inventory.variant.edit', ['inventory' => $inventory->id, 'variant' => $variant->id]) }}">
                                {{ __('Edit') }}
                            </a>
                        </li>
                        @endcan

                        @can('shop.inventory.variant.delete')
                        <li>
                            <form action="{{ route('admin.shop.inventory.variant.destroy', ['inventory' => $inventory->id, 'variant' => $variant->id]) }}"
                                method="POST"
                                onsubmit="return confirm('<?php echo __('Are you sure you want to delete this variant?') ?>');">

                                @csrf
                                @method('DELETE')
                                <button class="dropdown-item text-danger" type="submit">{{ __('Delete') }}</button>
                            </form>
                        </li>
                        @endcan
                    </ul>
                </div>
            </td>
        </tr>
        @empty
        <tr>
            <td colspan="8" class="text-center text-muted py-4">{{ __('No variants found.') }}</td>
        </tr>
        @endforelse
    </x-syndron.ui.table>


</div>
@endsection
