@extends('layouts.blesser.app')

@section('content')
<section class="">
    <div class="container py-5 mb-5">
        <div>
            @session('success')
            <x-blesser.ui.alert type="success" >
                {{ session('success') }}
            </x-blesser.ui.alert>
            @endsession
        </div>

        <x-blesser.element.pre-invoice-image-text />

        @auth
        <div class="rounded-lg bg-muted mb-5 p-3" id="pre-invoice-form">
            <h3 class="text-2xl font-bold my-5 text-center">
                {{ __('Submission Form') }}
            </h3>
            <livewire:blesser.pre-invoice-form />
        </div>

        @php
        $preInvoices = \App\Models\PreInvoice::with('items')
        ->where('creator_id', auth()->id())
        ->latest()
        ->paginate(10);

        $preInvoiceId = request()->get('pre-invoice', null);
        $preInvoice = $preInvoiceId !== null ? auth()->user()->preInvoices()->where('id', $preInvoiceId)->first() : null;
        @endphp

        <div
            x-data="{ tab: '{{ $preInvoice !== null ? 'details' : 'list' }}' }"
            class="rounded-lg bg-muted mb-5 p-3">
            <!-- Tabs Header -->
            <div class="flex justify-center gap-4 border-b border-gray-200 dark:border-gray-700 mb-4">
                <button
                    @click="tab = 'list'"
                    :class="tab === 'list' ? 'border-b-2 border-primary text-primary font-semibold' : 'text-gray-500 dark:text-gray-400 hover:text-primary'"
                    class="cursor-pointer px-4 py-2 text-sm transition-colors">
                    {{ __('Pre invoices list') }}
                </button>

                <button
                    @click="tab = 'details'"
                    :class="tab === 'details' ? 'border-b-2 border-primary text-primary font-semibold' : 'text-gray-500 dark:text-gray-400 hover:text-primary'"
                    class="cursor-pointer px-4 py-2 text-sm transition-colors">
                    {{ __('Pre invoice details') }}
                </button>
            </div>

            <!-- Tabs Content -->
            <div>
                <!-- List Tab -->
                <div x-show="tab === 'list'" x-transition.opacity>
                    <x-blesser.element.table.pre-invoices-table :preInvoices="$preInvoices" />
                </div>

                <!-- Details Tab -->
                <div x-show="tab === 'details'" x-transition.opacity>
                    @if ($preInvoice !== null)
                    <x-blesser.element.details.pre-invoice-details :preInvoice="$preInvoice" />
                    @else
                    <div class="text-center text-gray-500 dark:text-gray-400 py-8">
                        {{ __('No pre-invoice selected.') }}
                    </div>
                    @endif
                </div>
            </div>
        </div>
        @endauth

        @guest
        <div class="p-5">
            <x-blesser.ui.alert type="info">
                {{ __('for submitting a pre invoice please login to your account') }}
                |
                <a href="{{ route('login') }}">
                    {{ __('login') }}
                </a>
            </x-blesser.ui.alert>
        </div>
        @endguest
    </div>
</section>
@endsection
