<?php

use Illuminate\Support\Facades\Route;
use App\Http\Actions\Admin\MenuBuilderAction;
use App\Http\Controllers\Admin\OptionController;

Route::prefix('option')->name('option.')->group(function () {
    Route::get('/up', function () {
        return 'admin option route group is active';
    });
    Route::get('group/index', [OptionController::class, 'groupIndex'])->name('group-index');
    Route::get('panel', [OptionController::class, 'panel'])->name('panel');

    Route::view('panel-v2', 'pages.admin.option.panel-v2')->name('panel-v2');
    Route::post('panel-v2', [OptionController::class, 'panelV2'])->name('panel-v2.store');

    Route::put('update-all', [OptionController::class, 'updateAll'])->name('update-all');

    Route::view('menu' , 'pages.admin.option.menu')->name('menu');
    Route::post('menu' , MenuBuilderAction::class);
});
Route::resource('option', OptionController::class);
