<?php

use App\Http\Controllers\Admin\Settings\ImportController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\Settings\RoleController;
use App\Http\Controllers\Admin\Settings\CacheController;
use App\Http\Controllers\Admin\Settings\PermissionController;
use App\Http\Controllers\Admin\Settings\Ui\FooterSectionController;
use App\Http\Controllers\Admin\UserController;

Route::prefix('settings')->name('settings.')->group(function () {


    Route::prefix('ui')->name('ui.')->group(function () {
        Route::resource('footer-sections', FooterSectionController::class)->except(['create', 'show', 'destroy']);
    });

    Route::prefix('cache')->name('cache.')->group(function () {
        Route::get('/', [CacheController::class, 'index'])->name('index');
        Route::post('/refresh', [CacheController::class, 'refresh'])->name('refresh');
        Route::post('/clear', [CacheController::class, 'clear'])->name('clear');
        Route::post('/value', [CacheController::class, 'value'])->name('value');

        Route::post('/clear', [CacheController::class, 'clearAllCache'])->name('clear');
        Route::post('/build', [CacheController::class, 'cacheEverything'])->name('build');
    });

    Route::prefix('data')->name('data.')->group(function () {
        Route::prefix('import')->name('import.')->group(function () {
            Route::view('/', 'pages.admin.settings.data.import')->name('index');
            Route::post('/file', [ImportController::class, 'import'])->name('file');
        });
        Route::prefix('export')->name('export.')->group(function () {
            Route::view('/', 'pages.admin.settings.data.export')->name('index');
        });
    });

    Route::get('user/role/assign/{id}', [UserController::class, 'userRoleAssignForm'])->name('user.role.assign');
    Route::post('user/role/assign/{id}', [UserController::class, 'userRoleAssigns']);


    Route::resource('role', RoleController::class);
    Route::resource('permission', PermissionController::class);
    Route::resource('users', UserController::class);
});
