<?php

namespace Artemis\Faq\Http\Controllers\api\v1;

use Illuminate\Http\Request;
use Artemis\Faq\Traits\Votable;
use Artemis\Faq\Enums\VoteType;
use Illuminate\Http\JsonResponse;
use Illuminate\Database\Eloquent\Model;
use Artemis\Faq\Http\Controllers\api\ApiController;
use Symfony\Component\HttpFoundation\Response as ResponseCode;

class VoteController extends ApiController
{
    public function addVote(Request $request, string $votable, int $id): JsonResponse
    {
        /** @var Model|Votable $votableModel */
        $votableModel = resolveModelClass($votable, $id);
        
        $votableModel->upVote($request->user()->id);
        
        return $this->success(status: ResponseCode::HTTP_CREATED);
    }
    
    public function removeVote(Request $request, string $votable, int $id): JsonResponse
    {
        /** @var Model|Votable $votableModel */
        $votableModel = resolveModelClass($votable, $id);
        
        $votableModel->downVote($request->user()->id);
        
        return $this->success();
    }
    
    public function getVotes(string $votable, int $id): JsonResponse
    {
        /** @var Model|Votable $votableModel */
        $votableModel = resolveModelClass($votable, $id);
        
        $upVotes = $votableModel->votes()
            ->where('vote_type', VoteType::UP)
            ->count();
        $downVotes = $votableModel->votes()
            ->where('vote_type', VoteType::DOWN)
            ->count();
        
        $data = [
            'up' => $upVotes,
            'down' => $downVotes,
        ];
        
        return $this->success($data);
    }
}
