<?php

namespace Artemis\Faq\Http\Requests;

use Auth;
use Illuminate\Foundation\Http\FormRequest;

class CategoryUpdateRequest extends FormRequest
{
    public function authorize(): bool
    {
        return Auth::check();
    }
    
    public function rules(): array
    {
        return [
            'name' => ['sometimes', 'string', 'max:255'],
            'slug' => ['sometimes', 'string', 'max:255', 'unique:categories'],
            'description' => ['nullable', 'sometimes', 'string', 'max:500'],
        ];
    }
}
