<?php

namespace Artemis\Faq\Http\Requests;

use Auth;
use Illuminate\Foundation\Http\FormRequest;

class CommentStoreRequest extends FormRequest
{
    public function authorize(): bool
    {
        return Auth::check();
    }
    
    public function rules(): array
    {
        return [
            'commentable_id' => ['required', 'integer'],
            'commentable_type' => ['required', 'string'],
            'body' => ['required', 'string', 'max:1000'],
        ];
    }
}
