<?php

namespace Artemis\Faq\Traits;

/**
 * Trait HasEnumHelpers
 *
 * Provides utility methods for working with enums.
 */
trait HasEnumHelpers
{
    /**
     * Convert enum cases to an array.
     */
    public static function toArray(string $key = 'value'): array
    {
        return array_column(static::cases(), $key);
    }
    
    # NOTE: REQUIRES PHP ^8.3
    /**
     * Get the value of an enum case by name (case-sensitive).
     */
//    public static function valueOf(string $case)
//    {
//        return static::{$case}->value;
//    }
}
