# Artemis Laravel Loyalty System

A fully customizable **Customer Loyalty System** built as a Laravel package. Includes tiers, rewards, points tracking, referrals, and more.

---

## 📦 Installation

### Step 1: Require the package

```bash
composer require artemis/laravel-loyalty:dev-main
```

If you're working locally with a custom path (e.g. `app/Packages/Laravel-Loyalty`), make sure your `composer.json` includes:

```json
"autoload": {
  "psr-4": {
    "Artemis\\Loyalty\\": "app/Packages/Laravel-Loyalty/src/"
  }
},
"repositories": [
  {
    "type": "path",
    "url": "app/Packages/Laravel-Loyalty"
  }
],
"minimum-stability": "dev"
```

Then run:

```bash
composer dump-autoload
```

---

## 🔧 Configuration

### Step 2: Publish Config

```bash
php artisan vendor:publish --tag=loyalty-config
```

This publishes `config/loyalty.php` where you can customize:

* Route prefixes and middleware
* Feature toggles
* View paths for overriding Blade templates

---

## 🧱 Migrations

### Step 3: Publish and Run Migrations

```bash
php artisan loyalty:tables
php artisan migrate
```

---

## 🧪 Seed & Factories (Optional)

```bash
php artisan loyalty:seed
```

Seeds test tiers, rewards, and settings.

---

## 🧩 Blade Views

To override the default views:

```bash
php artisan loyalty:publish-views
```

Edit your own views inside: `resources/views/vendor/loyalty/...`

---

## 🧠 Traits for User Model

In your `User.php`:

```php
use Artemis\Loyalty\Concerns\HasLoyalty;

class User extends Authenticatable
{
    use HasLoyalty;
    // ...
}
```

---

## 📋 Routes

* Admin routes: auto-loaded via `routes/admin.php`
* Client routes: auto-loaded via `routes/web.php`
* API routes: auto-loaded via `routes/api.php`

All route prefixes, names, and middleware are configurable via `config/loyalty.php`

---

## ✅ Events and Listeners

The package includes events for:

* Points Earned
* Points Redeemed
* Referral Made
* Tier Upgraded
* Settings Updated

Handled by listeners automatically via `EventServiceProvider`.

---

## 🧪 Tests

Coming soon — prepare test classes in `tests/Feature/Loyalty` and `tests/Unit/Loyalty`

---

## 📁 Folder Structure Overview

```
app/Packages/Laravel-Loyalty/
├── config/
├── src/
│   ├── Console/Commands
│   ├── Concerns
│   ├── Events
│   ├── Listeners
│   ├── Http/Controllers
│   ├── Migrations
│   ├── Models
│   ├── Providers
│   └── resources/views
├── database/
│   ├── factories
│   └── seeders
├── routes/
└── Library/
```

---

## 🧠 Contributions

This package is in active development. Contributions and suggestions are welcome!
