<?php

namespace Artemis\Loyalty\Database\Factories;

use Artemis\Loyalty\Models\Tier;
use Illuminate\Database\Eloquent\Factories\Factory;

class TierFactory extends Factory
{
    protected $model = Tier::class;

    public function definition(): array
    {
        return [
            'name' => $this->faker->unique()->word,
            'min_points' => $this->faker->numberBetween(0, 1000),
            'max_points' => $this->faker->optional()->numberBetween(1001, 5000),
            'benefits' => ['free_shipping', 'early_access'],
        ];
    }
}
