<?php

namespace Artemis\Loyalty\Database\Seeders;

use Illuminate\Database\Seeder;
use Artemis\Loyalty\Models\Tier;
use Artemis\Loyalty\Models\Reward;
use Artemis\Loyalty\Models\LoyaltySetting;

class LoyaltySeeder extends Seeder
{
    public function run(): void
    {
        Tier::factory()->count(4)->create();
        Reward::factory()->count(10)->create();

        $settings = [
            'points_per_currency_unit' => '10',         // e.g. 10 points per $1
            'point_expiry_days' => '365',               // points expire after 1 year
            'referral_bonus' => '50',                   // points given to referrer
            'max_points_per_order' => '500',            // optional cap
            'redemption_enabled' => 'true',             // can users redeem rewards?
            'tiers_enabled' => 'true',                  // are tiers active?
            'referrals_enabled' => 'true',              // is referral system on?
        ];

        foreach ($settings as $key => $value) {
            LoyaltySetting::updateOrCreate(['key' => $key], ['value' => $value]);
        }
    }
}
