<?php


use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Route;
use Artemis\Loyalty\Http\Controllers\Admin\TierController;
use Artemis\Loyalty\Http\Actions\GenerateReferralCodesAction;
use Artemis\Loyalty\Http\Controllers\Admin\RewardController;
use Artemis\Loyalty\Http\Controllers\Admin\SettingController;
use Artemis\Loyalty\Http\Controllers\Admin\ReferralController;

$adminPrefix = config('loyalty.routes.admin.prefix', 'admin/loyalty');
$adminMiddleware = config('loyalty.routes.admin.middleware', ['web', 'auth', 'admin']);
$adminName = config('loyalty.routes.admin.name', 'admin.loyalty.');

Route::middleware($adminMiddleware)
    ->prefix($adminPrefix)
    ->name($adminName)
    ->group(function () {
        Route::view('dashboard', 'loyalty::admin.dashboard')->name('dashboard');

        Route::post('generate-referral-codes', GenerateReferralCodesAction::class)->name('generate-referral-codes');

        Route::resource('tiers', TierController::class);
        Route::resource('rewards', RewardController::class);
        Route::resource('referrals', ReferralController::class)->only(['index', 'show']);
        Route::get('settings/edit', [SettingController::class, 'edit'])->name('settings.edit');
        Route::post('settings/update', [SettingController::class, 'update'])->name('settings.update');
    });
