<?php

namespace Artemis\Loyalty\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Filesystem\Filesystem;

class PublishViewsCommand extends Command
{
    protected $signature = 'loyalty:publish-views';
    protected $description = 'Publish loyalty views and components to the host application';

    public function handle()
    {
        $filesystem = new Filesystem;

        $source = __DIR__ . '/../../resources/views';
        $target = config('loyalty.view_publish_path', resource_path('views/vendor/loyalty'));


        if (! $filesystem->isDirectory($source)) {
            $this->error('Source views not found.');
            return Command::FAILURE;
        }

        $filesystem->ensureDirectoryExists($target);
        $filesystem->copyDirectory($source, $target);

        $this->info('Loyalty views and components published to:');
        $this->line($target);

        return Command::SUCCESS;
    }
}
