<?php

namespace Artemis\Loyalty\Events;

use Illuminate\Queue\SerializesModels;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Broadcasting\InteractsWithSockets;


class ReferralMade
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public $referrer;
    public $referee;
    public $bonus;

    public function __construct($referrer, $referee, int $bonus = 0)
    {
        $this->referrer = $referrer;
        $this->referee = $referee;
        $this->bonus = $bonus;
    }
}
