<?php

namespace Artemis\Loyalty\Http\Controllers\Admin;

use Illuminate\Routing\Controller;
use Artemis\Loyalty\Models\Referral;

class ReferralController extends Controller
{
    public function index()
    {
        $referrals = Referral::with(['referrer', 'referee'])->latest()->get();
        return view('loyalty::admin.referrals.index', compact('referrals'));
    }

    public function show(Referral $referral)
    {
        $referral->load(['referrer', 'referee']);
        return view('loyalty::admin.referrals.show', compact('referral'));
    }
}
