<?php

namespace Artemis\Loyalty\Http\Controllers\Admin;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Artemis\Loyalty\Models\LoyaltySetting;

class SettingController extends Controller
{
    public function edit()
    {
        $settings = LoyaltySetting::all()->pluck('value', 'key')->toArray();
        return view('loyalty::admin.settings.edit', compact('settings'));
    }

    public function update(Request $request)
    {
        $data = $request->except(['_token']);

        foreach ($data as $key => $value) {
            LoyaltySetting::updateOrCreate(['key' => $key], ['value' => $value]);
        }

        return redirect()->route('admin.loyalty.settings.edit')
            ->with('success', __('Settings updated successfully.'));
    }
}
