<?php

namespace Artemis\Loyalty\Models;

use App\Models\User;
use Illuminate\Database\Eloquent\Model;

class Referral extends Model
{
    protected $fillable = [
        'referrer_id',
        'referee_id',
        'bonus_awarded'
    ];

    public function referrer()
    {
        return $this->belongsTo(User::class, 'referrer_id');
    }
    public function referee()
    {
        return $this->belongsTo(User::class, 'referee_id');
    }
}
